﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.CompetencePart
{
    public partial class UCTabCompetencePartCourses : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        public UCTabCompetencePartCourses()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCCompetencePartDetails UCDetails
        {
            get { return (UCCompetencePartDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            
            UCDetails.DataManager.Bindings.Add(_gTextBoxAbbreviationTheory, "CompetenceTheoryAbbreviation", _gLabelTheoryAbbreviation);
            UCDetails.DataManager.Bindings.Add(_gTextBoxAbbreviationCourse, "CompetenceCourseAbbreviation", _gLabelCourseAbbreviation);
            UCDetails.DataManager.Bindings.Add(_gTextBoxAbbreviationCase, "CaseAbbreviation", _gLabelCaseAbbreviation);

            _gftpControlTheoryImageFileID.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlTheoryImageFileID.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlTheoryImageFileID.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(TheoryImageChanged);
            _gPictureBoxTheory.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
            _gButtonEditDALTheoryCourse.Initialize(UCDetails.BLZSBELearning.RBL.ELearning.Course, AddTheory, true);

            _gftpControlCourseImageFileID.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlCourseImageFileID.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlCourseImageFileID.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(CourseImageChanged);
            _gPictureBoxCourse.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
            _gButtonEditDALCourse.Initialize(UCDetails.BLZSBELearning.RBL.ELearning.Course, AddCourse, true);

            _gftpControlCaseImageFileID.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlCaseImageFileID.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlCaseImageFileID.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(CaseImageChanged);
            _gPictureBoxCase.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
            _gButtonEditDALCase.Initialize(UCDetails.BLZSBELearning.RBL.ELearning.Course, AddCase, true);

        }

        void ImageLoadCompleted(object sender, AsyncCompletedEventArgs e)
        {
            Gemini.Core.WinForms.Controls.GPictureBox _gPictureBox = sender as Gemini.Core.WinForms.Controls.GPictureBox;

            if (_gPictureBox != null)
            {
                _gPictureBox.Visible = true;
            }

        }

        void TheoryImageChanged()
        {
            if (_gftpControlTheoryImageFileID.IsFileExist)
            {
                _gPictureBoxTheory.Visible = false;
                _gPictureBoxTheory.LoadAsync(_gftpControlTheoryImageFileID.URL);
            }
            else
            {
                _gPictureBoxTheory.Visible = false;
            }
        }

        void CourseImageChanged()
        {
            if (_gftpControlCourseImageFileID.IsFileExist)
            {
                _gPictureBoxCourse.Visible = false;
                _gPictureBoxCourse.LoadAsync(_gftpControlCourseImageFileID.URL);
            }
            else
            {
                _gPictureBoxCourse.Visible = false;
            }
        }

        void CaseImageChanged()
        {
            if (_gftpControlCaseImageFileID.IsFileExist)
            {
                _gPictureBoxCase.Visible = false;
                _gPictureBoxCase.LoadAsync(_gftpControlCaseImageFileID.URL);
            }
            else
            {
                _gPictureBoxCase.Visible = false;
            }
        }

        public override void DoRestore()
        {           
            if (UCDetails.DataManager.Current != null)
            {
                _gftpControlTheoryImageFileID.ID = UCDetails.DataManager.Current.CompetenceTheoryImageFileID;
                if (!String.IsNullOrEmpty(UCDetails.DataManager.Current.CompetenceTheoryImageFileURL))
                {
                    _gPictureBoxTheory.Visible = false;
                    _gPictureBoxTheory.LoadAsync(UCDetails.DataManager.Current.CompetenceTheoryImageFileURL);
                }
                else
                {
                    _gPictureBoxTheory.Visible = false;
                }


                _gftpControlCourseImageFileID.ID = UCDetails.DataManager.Current.CompetenceCourseImageFileID;
                if (!String.IsNullOrEmpty(UCDetails.DataManager.Current.CompetenceCourseImageFileURL))
                {
                    _gPictureBoxCourse.Visible = false;
                    _gPictureBoxCourse.LoadAsync(UCDetails.DataManager.Current.CompetenceCourseImageFileURL);
                }
                else
                {
                    _gPictureBoxCourse.Visible = false;
                }


                _gftpControlCaseImageFileID.ID = UCDetails.DataManager.Current.CaseImageFileID;
                if (!String.IsNullOrEmpty(UCDetails.DataManager.Current.CaseImageFileURL))
                {
                    _gPictureBoxCase.Visible = false;
                    _gPictureBoxCase.LoadAsync(UCDetails.DataManager.Current.CaseImageFileURL);
                }
                else
                {
                    _gPictureBoxCase.Visible = false;
                }


                _gButtonEditDALTheoryCourse.ID = UCDetails.DataManager.Current.CompetenceTheoryID;
                _gButtonEditDALCourse.ID = UCDetails.DataManager.Current.CompetenceCourseID;
                _gButtonEditDALCase.ID = UCDetails.DataManager.Current.CaseID;

                _gSpinEditCourseRandomizePercent.Value = UCDetails.DataManager.Current.CompetenceCourseRandomizePercent.HasValue ? UCDetails.DataManager.Current.CompetenceCourseRandomizePercent.Value : 100;
                _gSpinEditCaseRandomizePercent.Value = UCDetails.DataManager.Current.CaseRandomizePercent.HasValue ? UCDetails.DataManager.Current.CaseRandomizePercent.Value : 100;
            }
        }

        public override bool DoSave()
        {
            if (UCDetails.DataManager.Current != null)
            {
                if (_gftpControlTheoryImageFileID.IsFileExist)
                {
                    UCDetails.DataManager.Current.CompetenceTheoryImageFileID = _gftpControlTheoryImageFileID.ID;
                    UCDetails.DataManager.Current.CompetenceTheoryImageFileURL = _gftpControlTheoryImageFileID.URL;
                }
                else
                {
                    UCDetails.DataManager.Current.CompetenceTheoryImageFileID = null;
                    UCDetails.DataManager.Current.CompetenceTheoryImageFileURL = null;
                }


                if (_gftpControlCourseImageFileID.IsFileExist)
                {
                    UCDetails.DataManager.Current.CompetenceCourseImageFileID = _gftpControlCourseImageFileID.ID;
                    UCDetails.DataManager.Current.CompetenceCourseImageFileURL = _gftpControlCourseImageFileID.URL;
                }
                else
                {
                    UCDetails.DataManager.Current.CompetenceCourseImageFileID = null;
                    UCDetails.DataManager.Current.CompetenceCourseImageFileURL = null;
                }



                if (_gftpControlCaseImageFileID.IsFileExist)
                {
                    UCDetails.DataManager.Current.CaseImageFileID = _gftpControlCaseImageFileID.ID;
                    UCDetails.DataManager.Current.CaseImageFileURL = _gftpControlCaseImageFileID.URL;
                }
                else
                {
                    UCDetails.DataManager.Current.CaseImageFileID = null;
                    UCDetails.DataManager.Current.CaseImageFileURL = null;
                }



                UCDetails.DataManager.Current.CompetenceTheoryID = _gButtonEditDALTheoryCourse.ID;

                UCDetails.DataManager.Current.CompetenceCourseID = _gButtonEditDALCourse.ID;
                UCDetails.DataManager.Current.CompetenceCourseRandomizePercent = _gSpinEditCourseRandomizePercent.Value;

                UCDetails.DataManager.Current.CaseID = _gButtonEditDALCase.ID;
                UCDetails.DataManager.Current.CaseRandomizePercent = _gSpinEditCaseRandomizePercent.Value;

            }
            return true;
        }

        private Gemini.Core.BL.Interface.BO.IBaseUnique<long?> AddTheory()
        {
            PI.FM.N000.Base.WinForms.Classes.Param _param = new PI.FM.N000.Base.WinForms.Classes.Param(Gemini.Core.WinForms.Interface.ShowMode.ModalWindow);
            PI.GM.N610.ELearning.BL.BO.Course.Search _search = new PI.GM.N610.ELearning.BL.BO.Course.Search();
            _search.TypeID = UCDetails.BLZSBELearning.BLELearning.Categorizatoin.RestoreByEnum((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.CompetenceTheory).ID;
            Environment.WindowsHandler.Show(PI.GM.N610.ELearning.BL.Dictionary.WinFormsName, new Gemini.Core.WinForms.Base.AccessDescription(PI.GM.N610.ELearning.BL.Dictionary.Objects.UI.CourseList), _param, _search);

            return _param.Object;
        }

        private Gemini.Core.BL.Interface.BO.IBaseUnique<long?> AddCourse()
        {
            PI.FM.N000.Base.WinForms.Classes.Param _param = new PI.FM.N000.Base.WinForms.Classes.Param(Gemini.Core.WinForms.Interface.ShowMode.ModalWindow);
            PI.GM.N610.ELearning.BL.BO.Course.Search _search = new PI.GM.N610.ELearning.BL.BO.Course.Search();
            _search.TypeID = UCDetails.BLZSBELearning.BLELearning.Categorizatoin.RestoreByEnum((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.CompetenceCourse).ID;
            Environment.WindowsHandler.Show(PI.GM.N610.ELearning.BL.Dictionary.WinFormsName, new Gemini.Core.WinForms.Base.AccessDescription(PI.GM.N610.ELearning.BL.Dictionary.Objects.UI.CourseList), _param, _search);

            return _param.Object;
        }

        private Gemini.Core.BL.Interface.BO.IBaseUnique<long?> AddCase()
        {
            PI.FM.N000.Base.WinForms.Classes.Param _param = new PI.FM.N000.Base.WinForms.Classes.Param(Gemini.Core.WinForms.Interface.ShowMode.ModalWindow);
            PI.GM.N610.ELearning.BL.BO.Course.Search _search = new PI.GM.N610.ELearning.BL.BO.Course.Search();
            _search.TypeID = UCDetails.BLZSBELearning.BLELearning.Categorizatoin.RestoreByEnum((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.Case).ID;
            Environment.WindowsHandler.Show(PI.GM.N610.ELearning.BL.Dictionary.WinFormsName, new Gemini.Core.WinForms.Base.AccessDescription(PI.GM.N610.ELearning.BL.Dictionary.Objects.UI.CourseList), _param, _search);

            return _param.Object;
        }
    }
}
